#!/usr/bin/perl -w
#
# small perl script to gather specific data from lmsensors
#
# usage: lmsensors.pl identifier
#
# An identifier is expected to be something like temp3, fan2.
#
# version: $Id: lmsensors.pl,v 1.2 2002/08/18 23:49:46 als Exp $
#
# author: Alexander Schreiber <als@thangorodrim.de>
#


use strict;

# where it the lmsensors sensors binary
my $SENSORS='/usr/bin/sensors';


my ($line, $value);

if ( scalar(@ARGV) != 1 ) {
    print "usage: lmsensors.pl identifier\n";
    print "  An identifier is expected to be something like temp3, fan2.\n";
    exit(0);
}

my $key = $ARGV[0];

open(PIPE, "$SENSORS |") or die "cannot open pipe to sensors";
while ( $line = <PIPE> ) {
    chomp($line);
    if ( $line =~ /^$key:\s+(\S+)\s+/ ) {
        $value = $1;
        if ( $key =~ /^temp/ ) { # temperature are multiplied by 10
            $value =~ /^[+-](\d+\.*\d*)/;
            $value = $1 * 10;
        }
    }
}
close(PIPE);

printf("%d\n0\n0\n", $value);

