#!/usr/bin/perl -w
# This script is used to establish a TCP connection with a host to get the
# temperature info provided by in.hddtemp
#
# use: ./gettemp.pl <hostname> <disk device>
#
# versionL $Id: gettemp.pl,v 1.2 2002/08/21 12:25:08 als Exp $
#
# author: Alexander Schreiber <als@thangorodrim.de>
#

use Net::Telnet ();
use strict;

my ($hostname, $disk_device, $t, $data, $found, $port, $regex);

$hostname = $ARGV[0];
$disk_device = $ARGV[1];

# If you've changed the port showdisk.pl runs on, change it here too.
$port = 40005;


if ( scalar(@ARGV) != 2 )
{
  print "Usage: $0 <hostname> <disk device>\n";
  exit;
}

$t = new Net::Telnet ( Host => $hostname, Port => $port);
$t->open("$hostname");

$found = 0;
while ( $data = $t->getline(Timeout => 40) ) {
    chomp($data);
    $regex  = $disk_device;
    $regex .= ':\s.+:\s+(\d+)';
    if ( $data =~ /^$regex/ ) {
        print "$1\n0\n0\n";
        $found = 1;
    }
}

if ( $found == 0 ) {
    print "0\n0\n0\n";
}

