#!/usr/bin/perl
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.
#
# This library is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of 
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with this library; if not, write to the Free
# Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
#
# Perl script to do the data migration from an ipfm2psql 0.4 database
# to an ipfm2psql 0.5 database.
#
# author: Alexander Schreiber <als@thangorodrim.de>
#
# CVS: $Id: migrate.pl,v 1.4 2004/05/26 20:57:19 als Exp $
#


# Change the two hashes below to reflect your environment, OLD_ is where
# are reading the existing data from, NEW_ is where we write the converted
# data to.

%from = (
         db => 'OLD_DATABASE',
         host => 'OLD_SERVER',
         user => 'OLD_USER',
         password => 'OLD_PASSWORD'
        ); 

%to =  (
         db => 'NEW_DATABASE',
         host => 'NEW_SERVER',
         user => 'NEW_USER',
         password => 'NEW_PASSWORD'
        ); 

use DBI;

sub db_connect {

    my $dsn = shift;
    my $user = shift;
    my $password = shift;

    my $dbh;

    $dbh = DBI->connect($dsn, $user, $password,
                         { RaiseError => 1, AutoCommit => 0 });

    if ( not defined ($dbh) ) {
        print STDERR "Failed to connect to database ($dsn)!\n";
        return -1;
    } else {
        return $dbh;
    }
}


sub fetch_row {
    my $sth = shift;
    my $data;

    $sth->execute;
    $data = $sth->fetchrow_hashref;
    
    return $data;
}

# force flushed output
$| = 1;

$from_dsn = "dbi:Pg:dbname=$from{db} host=$from{host}";
$from_dbh = &db_connect($from_dsn, $from{user}, $from{password});


$to_dsn = "dbi:Pg:dbname=$to{db} host=$to{host}";
$to_dbh = &db_connect($to_dsn, $to{user}, $to{password});



#$from_dbh->begin_work;
print "declaring cursor ...";
$from_sql  = "declare fetch_all cursor for ";
$from_sql .= "SELECT date, time, host, incoming, outgoing from trafficlog";
$from_sth = $from_dbh->prepare($from_sql);
$from_sth->execute;

$from_sql = "fetch next from fetch_all";
$fetch_sth = $from_dbh->prepare($from_sql);


print "done.\n";

$current = 0;
#$to_dbh->begin_work;
print "migrating record: 0000000000";

while ( $from_data = &fetch_row($fetch_sth)) {
    $current++;
    # only print every 100 rows
    if ( ( $current % 1000 ) == 0 ) {
        $to_dbh->commit;
        print "\b\b\b\b\b\b\b\b\b\b";
        printf "%-10d", $current;
        $to_dbh-begin_work;
    }
    # write the hostname
    $to_sql = "insert into hosts (hostname) values ('$from_data->{host}')";
    $to_sth = $to_dbh->prepare($to_sql);
    $to_sth->execute;
    
    # write the traffic record
    $to_sql  = "insert into trafficentries ";
    $to_sql .= "(date, time, host, incoming, outgoing) ";
    $to_sql .= "values (";
    $to_sql .= "'$from_data->{date}', ";
    $to_sql .= "'$from_data->{time}', ";
    $to_sql .= "(select id from hosts where hostname = ";
    $to_sql .= "'$from_data->{host}'), ";
    $to_sql .= "$from_data->{incoming}, ";
    $to_sql .= "$from_data->{outgoing})";
    $to_sth = $to_dbh->prepare($to_sql);
    $to_sth->execute;
}

print "\n\n";
print "All done, exiting.\n";

$from_dbh->commit;
$to_dbh->commit;

$from_dbh->disconnect;
$to_db->disconnect;

