/*
 * Displays a large clock
 *
 * author: Alexander Schreiber <als@thangorodrim.de>
 *
 * version: 1.1
 * CVS: $Id: clock.c 728 2003-04-21 19:26:58Z als $
 * note: written for DOS and not portable
 *
 */


 /*
  *
  */

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <conio.h>
#include <dos.h>

#include "font.h"


#define MODE_CLOCK     1
#define MODE_COUNTUP   2
#define MODE_COUNTDOWN 3
#define MODE_STOPWATCH 4


extern char font[11][8][16];


void display_centered (char * time_str) {
/*
 * displays time in the middle of the display, expects time_str
 * as HH:MM:SS
 */

  int x, y;

  clrscr();
  gotoxy(35, 12);
  puts(time_str);


}


void display_large (char * time_str) {
/*
 * displays time centered in large font
 * expects time_str as HH:MM:SS
 *
 */


  int num_pos, number, line, cline, x, cx, nx;
  int time_code[8];
  char buffer[65];
  int start;

  memset(buffer, 0, 65);

  /* convert to numeral codes */
  for ( num_pos = 0; num_pos < 8; num_pos++ ) {
	time_code[num_pos] = c2i(time_str[num_pos]);
/*	printf("position %d code %d\n", num_pos, time_code[num_pos]); */
  }

  clrscr();


  start = 8;

  for ( line = 0; line < 8; line++ ) {
	cline = 2 * line;
	for ( x = 0; x < 64; x++ ) {
	  cx = x % 8;
	  nx = x / 8;
	  number = time_code[nx];
	  buffer[x] = font[number][cx][cline];
	}
	gotoxy(start, cline + 6);
	cputs(buffer);

	cline = 16 - (2 * line + 1);
	for ( x = 0; x < 64; x++ ) {
	  cx = x % 8;
	  nx = x / 8;
	  number = time_code[nx];
	  buffer[x] = font[number][cx][cline];
	}
	gotoxy(start, cline + 6);
	cputs(buffer);

	gotoxy(79,24);
  }
}


void display_diff (char * time_str) {
/*
 * displays time centered in large font
 * expects time_str as HH:MM:SS
 * uses differential update
 *
 * updates are much faster, practically instantly
 */


  int num_pos, number, line, cline, x, cx, nx;
  int time_code[8];
  char buffer[65];
  int start;
  typedef char display_buffer[16][65];
  static display_buffer old_display, new_display;
  static buffer_init = 0;

  memset(buffer, 0, 65);

  /* convert to numeral codes */
  for ( num_pos = 0; num_pos < 8; num_pos++ ) {
	time_code[num_pos] = c2i(time_str[num_pos]);
/*	printf("position %d code %d\n", num_pos, time_code[num_pos]); */
  }


  start = 8;
  if ( buffer_init == 0 ) { /* important: init diff buffers only once */
	clrscr();
	memset(old_display, 0, sizeof(display_buffer));
	memset(new_display, 0, sizeof(display_buffer));
	buffer_init = 1;
  }

  for ( line = 0; line < 16; line++ ) {
	for ( x = 0; x < 64; x++ ) {
	  cx = x % 8;
	  nx = x / 8;
	  number = time_code[nx];
	  buffer[x] = font[number][cx][line];
	}
	strncpy(new_display[line], buffer, 65);  /* print to diff buffer */
  }


/*
 * find differences between old and new output and update only changed
 * sections of the screen. Doing this opn a per-character-level instead
 * off over the entire pixmap would be even faster, but its basically
 * already fast enough
 *
 */

  for (line = 0; line < 16; line++ ) {
	for ( x = 0; x < 64; x++ ) {
	   if ( old_display[line][x] != new_display[line][x] ) {
		 gotoxy(x + start, line + 5);
		 putch(new_display[line][x]);
	   }
	}
  }
  gotoxy(79, 24);
  memcpy(old_display, new_display, sizeof(display_buffer));
}


void timer_loop(char * time_mode) {
  time_t cur_time, old_time, sys_time, start_time;
  struct tm * time_ptr;
  char time_str[9];
  int mode;
  time_t work;
  int rem;

  int end_display = 0;


  if ( strcmp(time_mode, "clock") == 0 ) {
	mode = MODE_CLOCK;
  } else {
	if ( strcmp(time_mode, "stopwatch") == 0 ) {
	  mode = MODE_STOPWATCH;
	  start_time = time(&old_time);
	} else {
	   mode = MODE_CLOCK;
	}
  }
  old_time = 0;
  while ( end_display == 0 ) {
	if  ( mode == MODE_CLOCK ) {
	  cur_time = time(&cur_time);
	} else {     /* stopwatch */
	  sys_time = time(&sys_time);
	  cur_time = sys_time - start_time;
	}
	if (cur_time > old_time) {
	  if ( mode == MODE_CLOCK ) {
		time_ptr = localtime(&cur_time);
	  } else {   /* stop watch */
		time_ptr->tm_sec = (int) cur_time % 60;
		work = cur_time / 60;
		time_ptr->tm_min = (int) work % 60;
		work = work / 60;
		time_ptr->tm_hour = (int) work % 100;
	  }
	  sprintf(time_str, "%02d:%02d:%02d", time_ptr->tm_hour, time_ptr->tm_min,
			  time_ptr->tm_sec);
	  display_diff(time_str);
	  if ( kbhit() ) end_display = 1;
	}
	old_time = cur_time;
  }
}



void watch_loop(void) {
  time_t cur_time, old_time;
  struct tm * time_ptr;
  char time_str[9];
  time_t work;

  int end_display = 0;


  old_time = 0;
  while ( end_display == 0 ) {
	cur_time = time(&cur_time);
	if (cur_time > old_time) {
	  time_ptr = localtime(&cur_time);
	  sprintf(time_str, "%02d:%02d:%02d", time_ptr->tm_hour, time_ptr->tm_min,
			  time_ptr->tm_sec);
	  display_diff(time_str);
	  if ( kbhit() ) end_display = 1;
	}
	old_time = cur_time;
  }
}


void show_help (void) {

  puts("timer 1.1 - displays a large font clock/stopwatch");
  puts("Copyright (c) 2002 Alexander Schreiber als@thangorodrim.de");
  puts("usage: timer clock     - display large font clock");
  puts("       timer stopwatch - dipsplay large font stopwatch");
  puts("The program will run until a key is pressed and exit then.");

}


int main(int argc, char **argv) {

  if ( argc < 2 ) {
	 show_help();
	 exit(0);
  }
  init_font();
  timer_loop(argv[1]);

  return 0;
}
